#!/usr/bin/env bash

if [ "$EUID" -ne 0 ]; then
    script_path=$([[ "$0" = /* ]] && echo "$0" || echo "$PWD/${0#./}")
    sudo "$script_path" || (
        echo 'Administrator privileges are required.'
        exit 1
    )
    exit 0
fi


# ----------------------------------------------------------
# --------------------Clear bash history--------------------
# ----------------------------------------------------------
echo '--- Clear bash history'
rm -f ~/.bash_history
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------------Clear zsh history---------------------
# ----------------------------------------------------------
echo '--- Clear zsh history'
rm -f ~/.zsh_history
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------------Clear diagnostic logs-------------------
# ----------------------------------------------------------
echo '--- Clear diagnostic logs'
# Clear directory contents: "/private/var/db/diagnostics"
glob_pattern="/private/var/db/diagnostics/*"
sudo rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear diagnostic log details---------------
# ----------------------------------------------------------
echo '--- Clear diagnostic log details'
# Clear directory contents: "/private/var/db/uuidtext"
glob_pattern="/private/var/db/uuidtext/*"
sudo rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------Clear Apple System Logs (ASL)---------------
# ----------------------------------------------------------
echo '--- Clear Apple System Logs (ASL)'
# Clear directory contents: "/private/var/log/asl"
glob_pattern="/private/var/log/asl/*"
sudo rm -rfv $glob_pattern
# Delete files matching pattern: "/private/var/log/asl.log"
glob_pattern="/private/var/log/asl.log"
sudo rm -fv $glob_pattern
# Delete files matching pattern: "/private/var/log/asl.db"
glob_pattern="/private/var/log/asl.db"
sudo rm -fv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------------Clear installation logs------------------
# ----------------------------------------------------------
echo '--- Clear installation logs'
# Delete files matching pattern: "/private/var/log/install.log"
glob_pattern="/private/var/log/install.log"
sudo rm -fv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------------Clear all system logs-------------------
# ----------------------------------------------------------
echo '--- Clear all system logs'
# Clear directory contents: "/private/var/log"
glob_pattern="/private/var/log/*"
sudo rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------Clear system application logs---------------
# ----------------------------------------------------------
echo '--- Clear system application logs'
# Clear directory contents: "/Library/Logs"
glob_pattern="/Library/Logs/*"
sudo rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear user application logs----------------
# ----------------------------------------------------------
echo '--- Clear user application logs'
# Clear directory contents: "$HOME/Library/Logs"
glob_pattern="$HOME/Library/Logs/*"
 rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------------Clear Mail app logs--------------------
# ----------------------------------------------------------
echo '--- Clear Mail app logs'
# Clear directory contents: "$HOME/Library/Containers/com.apple.mail/Data/Library/Logs/Mail"
glob_pattern="$HOME/Library/Containers/com.apple.mail/Data/Library/Logs/Mail/*"
 rm -rfv $glob_pattern
# ----------------------------------------------------------


# Clear user activity audit logs (login, logout, authentication, etc.)
echo '--- Clear user activity audit logs (login, logout, authentication, etc.)'
# Clear directory contents: "/private/var/audit"
glob_pattern="/private/var/audit/*"
sudo rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------Clear system maintenance logs---------------
# ----------------------------------------------------------
echo '--- Clear system maintenance logs'
# Delete files matching pattern: "/private/var/log/daily.out"
glob_pattern="/private/var/log/daily.out"
sudo rm -fv $glob_pattern
# Delete files matching pattern: "/private/var/log/weekly.out"
glob_pattern="/private/var/log/weekly.out"
sudo rm -fv $glob_pattern
# Delete files matching pattern: "/private/var/log/monthly.out"
glob_pattern="/private/var/log/monthly.out"
sudo rm -fv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear app installation logs----------------
# ----------------------------------------------------------
echo '--- Clear app installation logs'
# Clear directory contents: "/private/var/db/receipts"
glob_pattern="/private/var/db/receipts/*"
sudo rm -rfv $glob_pattern
# Delete files matching pattern: "/Library/Receipts/InstallHistory.plist"
glob_pattern="/Library/Receipts/InstallHistory.plist"
 rm -fv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Clear privacy.sexy script history-------------
# ----------------------------------------------------------
echo '--- Clear privacy.sexy script history'
# Clear directory contents: "$HOME/Library/Application Support/privacy.sexy/runs"
glob_pattern="$HOME/Library/Application Support/privacy.sexy/runs/*"
 rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------Clear privacy.sexy activity logs-------------
# ----------------------------------------------------------
echo '--- Clear privacy.sexy activity logs'
# Clear directory contents: "$HOME/Library/Logs/privacy.sexy"
glob_pattern="$HOME/Library/Logs/privacy.sexy/*"
 rm -rfv $glob_pattern
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------------Clear Adobe cache---------------------
# ----------------------------------------------------------
echo '--- Clear Adobe cache'
sudo rm -rfv ~/Library/Application\ Support/Adobe/Common/Media\ Cache\ Files/* &>/dev/null
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------------Clear Gradle cache--------------------
# ----------------------------------------------------------
echo '--- Clear Gradle cache'
if [ -d "~/.gradle/caches" ]; then
    rm -rfv ~/.gradle/caches/ &> /dev/null
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------------Clear Dropbox cache--------------------
# ----------------------------------------------------------
echo '--- Clear Dropbox cache'
if [ -d "~/Dropbox/.dropbox.cache" ]; then
    sudo rm -rfv ~/Dropbox/.dropbox.cache/* &>/dev/null
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear Google Drive File Stream cache-----------
# ----------------------------------------------------------
echo '--- Clear Google Drive File Stream cache'
killall "Google Drive File Stream"
rm -rfv ~/Library/Application\ Support/Google/DriveFS/[0-9a-zA-Z]*/content_cache &>/dev/null
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------------Clear Composer cache-------------------
# ----------------------------------------------------------
echo '--- Clear Composer cache'
if type "composer" &> /dev/null; then
    composer clearcache &> /dev/null
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------------Clear Homebrew cache-------------------
# ----------------------------------------------------------
echo '--- Clear Homebrew cache'
if type "brew" &>/dev/null; then
    brew cleanup -s &>/dev/null
    rm -rfv $(brew --cache) &>/dev/null
    brew tap --repair &>/dev/null
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear old Ruby gem versions----------------
# ----------------------------------------------------------
echo '--- Clear old Ruby gem versions'
if type "gem" &> /dev/null; then
    gem cleanup &>/dev/null
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------------Clear unused Docker data-----------------
# ----------------------------------------------------------
echo '--- Clear unused Docker data'
if type "docker" &> /dev/null; then
    docker system prune -af
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear Pyenv-Virtualenv cache---------------
# ----------------------------------------------------------
echo '--- Clear Pyenv-Virtualenv cache'
if [ "$PYENV_VIRTUALENV_CACHE_PATH" ]; then
    rm -rfv $PYENV_VIRTUALENV_CACHE_PATH &>/dev/null
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------------Clear NPM cache----------------------
# ----------------------------------------------------------
echo '--- Clear NPM cache'
if type "npm" &> /dev/null; then
    npm cache clean --force
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------------Clear Yarn cache---------------------
# ----------------------------------------------------------
echo '--- Clear Yarn cache'
if type "yarn" &> /dev/null; then
    echo 'Cleanup Yarn Cache...'
    yarn cache clean --force
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear **"All"** permissions----------------
# ----------------------------------------------------------
echo '--- Clear **"All"** permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='All'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------------Clear "Camera" permissions----------------
# ----------------------------------------------------------
echo '--- Clear "Camera" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='Camera'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------Clear "Microphone" permissions--------------
# ----------------------------------------------------------
echo '--- Clear "Microphone" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='Microphone'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Clear "Accessibility" permissions-------------
# ----------------------------------------------------------
echo '--- Clear "Accessibility" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='Accessibility'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Clear "Screen Capture" permissions------------
# ----------------------------------------------------------
echo '--- Clear "Screen Capture" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='ScreenCapture'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------Clear "Reminders" permissions---------------
# ----------------------------------------------------------
echo '--- Clear "Reminders" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='Reminders'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------------Clear "Photos" permissions----------------
# ----------------------------------------------------------
echo '--- Clear "Photos" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='Photos'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear "Calendar" permissions---------------
# ----------------------------------------------------------
echo '--- Clear "Calendar" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='Calendar'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear "Full Disk Access" permissions-----------
# ----------------------------------------------------------
echo '--- Clear "Full Disk Access" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyAllFiles'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear "Contacts" permissions---------------
# ----------------------------------------------------------
echo '--- Clear "Contacts" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='AddressBook'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Clear "Desktop Folder" permissions------------
# ----------------------------------------------------------
echo '--- Clear "Desktop Folder" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyDesktopFolder'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear "Documents Folder" permissions-----------
# ----------------------------------------------------------
echo '--- Clear "Documents Folder" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyDocumentsFolder'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear "Downloads Folder" permissions-----------
# ----------------------------------------------------------
echo '--- Clear "Downloads Folder" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyDownloadsFolder'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------Clear "Apple Events" permissions-------------
# ----------------------------------------------------------
echo '--- Clear "Apple Events" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='AppleEvents'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------Clear "File Provider Presence" permissions--------
# ----------------------------------------------------------
echo '--- Clear "File Provider Presence" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='FileProviderPresence'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Clear "Listen Events" permissions-------------
# ----------------------------------------------------------
echo '--- Clear "Listen Events" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='ListenEvent'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Clear "Media Library" permissions-------------
# ----------------------------------------------------------
echo '--- Clear "Media Library" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='MediaLibrary'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------Clear "Post Event" permissions--------------
# ----------------------------------------------------------
echo '--- Clear "Post Event" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='PostEvent'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------Clear "Speech Recognition" permissions----------
# ----------------------------------------------------------
echo '--- Clear "Speech Recognition" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SpeechRecognition'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear "App Modification" permissions-----------
# ----------------------------------------------------------
echo '--- Clear "App Modification" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyAppBundles'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear "Application Data" permissions-----------
# ----------------------------------------------------------
echo '--- Clear "Application Data" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyAppData'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear "Network Volumes" permissions------------
# ----------------------------------------------------------
echo '--- Clear "Network Volumes" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyNetworkVolumes'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------Clear "Removable Volumes" permissions-----------
# ----------------------------------------------------------
echo '--- Clear "Removable Volumes" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicyRemovableVolumes'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----Clear "System Administration Files" permissions------
# ----------------------------------------------------------
echo '--- Clear "System Administration Files" permissions'
if ! command -v 'tccutil' &> /dev/null; then
    echo 'Skipping because "tccutil" is not found.'
else
    declare serviceId='SystemPolicySysAdminFiles'
declare reset_output reset_exit_code
{
    reset_output=$(tccutil reset "$serviceId" 2>&1)
    reset_exit_code=$?
}
if [ $reset_exit_code -eq 0 ]; then
    echo "Successfully reset permissions for \"${serviceId}\"."
elif [ $reset_exit_code -eq 70 ]; then
    echo "Skipping, service ID \"${serviceId}\" is not supported on your operating system version."
elif [ $reset_exit_code -ne 0 ]; then
    >&2 echo "Failed to reset permissions for \"${serviceId}\". Exit code: $reset_exit_code."
    if [ -n "$reset_output" ]; then
        echo "Output from \`tccutil\`: $reset_output."
    fi
fi
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------Clear iOS app copies from iTunes-------------
# ----------------------------------------------------------
echo '--- Clear iOS app copies from iTunes'
rm -rfv ~/Music/iTunes/iTunes\ Media/Mobile\ Applications/* &>/dev/null
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------------Clear iOS photo cache-------------------
# ----------------------------------------------------------
echo '--- Clear iOS photo cache'
rm -rf ~/Pictures/iPhoto\ Library/iPod\ Photo\ Cache/*
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------------Clear iOS Device Backups-----------------
# ----------------------------------------------------------
echo '--- Clear iOS Device Backups'
rm -rfv ~/Library/Application\ Support/MobileSync/Backup/* &>/dev/null
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------------Clear iOS simulators-------------------
# ----------------------------------------------------------
echo '--- Clear iOS simulators'
if type "xcrun" &>/dev/null; then
    osascript -e 'tell application "com.apple.CoreSimulator.CoreSimulatorService" to quit'
    osascript -e 'tell application "iOS Simulator" to quit'
    osascript -e 'tell application "Simulator" to quit'
    xcrun simctl shutdown all
    xcrun simctl erase all
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Clear list of connected iOS devices------------
# ----------------------------------------------------------
echo '--- Clear list of connected iOS devices'
sudo defaults delete /Users/$USER/Library/Preferences/com.apple.iPod.plist "conn:128:Last Connect"
sudo defaults delete /Users/$USER/Library/Preferences/com.apple.iPod.plist Devices
sudo defaults delete /Library/Preferences/com.apple.iPod.plist "conn:128:Last Connect"
sudo defaults delete /Library/Preferences/com.apple.iPod.plist Devices
sudo rm -rfv /var/db/lockdown/*
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Clear CUPS printer job cache---------------
# ----------------------------------------------------------
echo '--- Clear CUPS printer job cache'
sudo rm -rfv /var/spool/cups/c0*
sudo rm -rfv /var/spool/cups/tmp/*
sudo rm -rfv /var/spool/cups/cache/job.cache*
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------------Empty trash on all volumes----------------
# ----------------------------------------------------------
echo '--- Empty trash on all volumes'
# on all mounted volumes
sudo rm -rfv /Volumes/*/.Trashes/* &>/dev/null
# on main HDD
sudo rm -rfv ~/.Trash/* &>/dev/null
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------------Clear system cache--------------------
# ----------------------------------------------------------
echo '--- Clear system cache'
sudo rm -rfv /Library/Caches/* &>/dev/null
sudo rm -rfv /System/Library/Caches/* &>/dev/null
sudo rm -rfv ~/Library/Caches/* &>/dev/null
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------Clear Xcode's derived data and archives----------
# ----------------------------------------------------------
echo '--- Clear Xcode'\''s derived data and archives'
rm -rfv ~/Library/Developer/Xcode/DerivedData/* &>/dev/null
rm -rfv ~/Library/Developer/Xcode/Archives/* &>/dev/null
rm -rfv ~/Library/Developer/Xcode/iOS Device Logs/* &>/dev/null
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------------Clear DNS cache----------------------
# ----------------------------------------------------------
echo '--- Clear DNS cache'
sudo dscacheutil -flushcache
sudo killall -HUP mDNSResponder
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------------Clear inactive memory-------------------
# ----------------------------------------------------------
echo '--- Clear inactive memory'
sudo purge
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------------Remove Guest User---------------------
# ----------------------------------------------------------
echo '--- Remove Guest User'
if ! command -v 'sysadminctl' &> /dev/null; then
    echo 'Skipping because "sysadminctl" is not found.'
else
    sudo sysadminctl -deleteUser Guest
fi
if ! command -v 'fdesetup' &> /dev/null; then
    echo 'Skipping because "fdesetup" is not found.'
else
    sudo fdesetup remove -user Guest
fi
if ! command -v 'dscl' &> /dev/null; then
    echo 'Skipping because "dscl" is not found.'
else
    sudo dscl . delete /Users/Guest
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# Disable automatic downloads for Parallels Desktop updates-
# ----------------------------------------------------------
echo '--- Disable automatic downloads for Parallels Desktop updates'
defaults write 'com.parallels.Parallels Desktop' 'Application preferences.Download updates automatically' -bool no
# ----------------------------------------------------------


# ----------------------------------------------------------
# --Disable automatic checks for Parallels Desktop updates--
# ----------------------------------------------------------
echo '--- Disable automatic checks for Parallels Desktop updates'
defaults write 'com.parallels.Parallels Desktop' 'Application preferences.Check for updates' -int 0
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------Disable Parallels Desktop advertisements---------
# ----------------------------------------------------------
echo '--- Disable Parallels Desktop advertisements'
defaults write 'com.parallels.Parallels Desktop' 'ProductPromo.ForcePromoOff' -bool yes
defaults write 'com.parallels.Parallels Desktop' 'WelcomeScreenPromo.PromoOff' -bool yes
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Disable Microsoft Office telemetry------------
# ----------------------------------------------------------
echo '--- Disable Microsoft Office telemetry'
defaults write com.microsoft.office DiagnosticDataTypePreference -string ZeroDiagnosticData
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------Remove Google Software Update service-----------
# ----------------------------------------------------------
echo '--- Remove Google Software Update service'
googleUpdateFile=~/Library/Google/GoogleSoftwareUpdate/GoogleSoftwareUpdate.bundle/Contents/Resources/ksinstall
if [ -f "$googleUpdateFile" ]; then
    $googleUpdateFile --nuke
    echo 'Uninstalled Google update'
else
    echo 'Google update file does not exist'
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------Disable Homebrew user behavior analytics---------
# ----------------------------------------------------------
echo '--- Disable Homebrew user behavior analytics'
command='export HOMEBREW_NO_ANALYTICS=1'
declare -a profile_files=("$HOME/.bash_profile" "$HOME/.zprofile")
for profile_file in "${profile_files[@]}"
do
    touch "$profile_file"
    if ! grep -q "$command" "${profile_file}"; then
        echo "$command" >> "$profile_file"
        echo "[$profile_file] Configured"
    else
        echo "[$profile_file] No need for any action, already configured"
    fi
done
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------Disable NET Core CLI telemetry--------------
# ----------------------------------------------------------
echo '--- Disable NET Core CLI telemetry'
command='export DOTNET_CLI_TELEMETRY_OPTOUT=1'
declare -a profile_files=("$HOME/.bash_profile" "$HOME/.zprofile")
for profile_file in "${profile_files[@]}"
do
    touch "$profile_file"
    if ! grep -q "$command" "${profile_file}"; then
        echo "$command" >> "$profile_file"
        echo "[$profile_file] Configured"
    else
        echo "[$profile_file] No need for any action, already configured"
    fi
done
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Disable PowerShell Core telemetry-------------
# ----------------------------------------------------------
echo '--- Disable PowerShell Core telemetry'
command='export POWERSHELL_TELEMETRY_OPTOUT=1'
declare -a profile_files=("$HOME/.bash_profile" "$HOME/.zprofile")
for profile_file in "${profile_files[@]}"
do
    touch "$profile_file"
    if ! grep -q "$command" "${profile_file}"; then
        echo "$command" >> "$profile_file"
        echo "[$profile_file] Configured"
    else
        echo "[$profile_file] No need for any action, already configured"
    fi
done
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------------Disable Firefox telemetry-----------------
# ----------------------------------------------------------
echo '--- Disable Firefox telemetry'
# Enable Firefox policies so the telemetry can be configured.
sudo defaults write /Library/Preferences/org.mozilla.firefox EnterprisePoliciesEnabled -bool TRUE
# Disable sending usage data
sudo defaults write /Library/Preferences/org.mozilla.firefox DisableTelemetry -bool TRUE
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Disable remote management service-------------
# ----------------------------------------------------------
echo '--- Disable remote management service'
sudo /System/Library/CoreServices/RemoteManagement/ARDAgent.app/Contents/Resources/kickstart -deactivate -stop
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Remove Apple Remote Desktop Settings-----------
# ----------------------------------------------------------
echo '--- Remove Apple Remote Desktop Settings'
sudo rm -rf /var/db/RemoteManagement
sudo defaults delete /Library/Preferences/com.apple.RemoteDesktop.plist
defaults delete ~/Library/Preferences/com.apple.RemoteDesktop.plist
sudo rm -rf /Library/Application\ Support/Apple/Remote\ Desktop/
rm -r ~/Library/Application\ Support/Remote\ Desktop/
rm -r ~/Library/Containers/com.apple.RemoteDesktop
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------------Disable "Ask Siri"--------------------
# ----------------------------------------------------------
echo '--- Disable "Ask Siri"'
defaults write com.apple.assistant.support 'Assistant Enabled' -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Disable Siri voice feedback----------------
# ----------------------------------------------------------
echo '--- Disable Siri voice feedback'
defaults write com.apple.assistant.backedup 'Use device speaker for TTS' -int 3
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------Disable Siri services (Siri and assistantd)--------
# ----------------------------------------------------------
echo '--- Disable Siri services (Siri and assistantd)'
launchctl disable "user/$UID/com.apple.assistantd"
launchctl disable "gui/$UID/com.apple.assistantd"
sudo launchctl disable 'system/com.apple.assistantd'
launchctl disable "user/$UID/com.apple.Siri.agent"
launchctl disable "gui/$UID/com.apple.Siri.agent"
sudo launchctl disable 'system/com.apple.Siri.agent'
if [ $(/usr/bin/csrutil status | awk '/status/ {print $5}' | sed 's/\.$//') = "enabled" ]; then
    >&2 echo 'This script requires SIP to be disabled. Read more: https://developer.apple.com/documentation/security/disabling_and_enabling_system_integrity_protection'
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------Disable "Do you want to enable Siri?" pop-up-------
# ----------------------------------------------------------
echo '--- Disable "Do you want to enable Siri?" pop-up'
defaults write com.apple.SetupAssistant 'DidSeeSiriSetup' -bool True
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------------Remove Siri from menu bar-----------------
# ----------------------------------------------------------
echo '--- Remove Siri from menu bar'
defaults write com.apple.systemuiserver 'NSStatusItem Visible Siri' 0
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Remove Siri from status menu---------------
# ----------------------------------------------------------
echo '--- Remove Siri from status menu'
defaults write com.apple.Siri 'StatusMenuVisible' -bool false
defaults write com.apple.Siri 'UserHasDeclinedEnable' -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------Disable participation in Siri data collection-------
# ----------------------------------------------------------
echo '--- Disable participation in Siri data collection'
defaults write com.apple.assistant.support 'Siri Data Sharing Opt-In Status' -int 2
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------Disable online spell correction--------------
# ----------------------------------------------------------
echo '--- Disable online spell correction'
defaults write NSGlobalDomain WebAutomaticSpellingCorrectionEnabled -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Disable remote Apple events----------------
# ----------------------------------------------------------
echo '--- Disable remote Apple events'
sudo systemsetup -setremoteappleevents off
# ----------------------------------------------------------


# ----------------------------------------------------------
# --Disable automatic storage of documents in iCloud Drive--
# ----------------------------------------------------------
echo '--- Disable automatic storage of documents in iCloud Drive'
defaults write NSGlobalDomain NSDocumentSaveNewDocumentsToCloud -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------Disable display of recent applications on Dock------
# ----------------------------------------------------------
echo '--- Disable display of recent applications on Dock'
defaults write com.apple.dock show-recents -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Disable AirDrop file sharing---------------
# ----------------------------------------------------------
echo '--- Disable AirDrop file sharing'
defaults write com.apple.NetworkBrowser DisableAirDrop -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------------Disable Spotlight indexing----------------
# ----------------------------------------------------------
echo '--- Disable Spotlight indexing'
sudo mdutil -i off -d /
# ----------------------------------------------------------


# Disable personalized advertisements and identifier tracking
echo '--- Disable personalized advertisements and identifier tracking'
defaults write com.apple.AdLib allowIdentifierForAdvertising -bool false
defaults write com.apple.AdLib allowApplePersonalizedAdvertising -bool false
defaults write com.apple.AdLib forceLimitAdTracking -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------Disable date and time in screenshot filenames-------
# ----------------------------------------------------------
echo '--- Disable date and time in screenshot filenames'
defaults write 'com.apple.screencapture' 'include-date' -bool false
killall SystemUIServer
# ----------------------------------------------------------


# ----------------------------------------------------------
# --Disable automatic incoming connections for signed apps--
# ----------------------------------------------------------
echo '--- Disable automatic incoming connections for signed apps'
sudo defaults write /Library/Preferences/com.apple.alf allowsignedenabled -bool false
# ----------------------------------------------------------


# Disable automatic incoming connections for downloaded signed apps
echo '--- Disable automatic incoming connections for downloaded signed apps'
sudo defaults write /Library/Preferences/com.apple.alf allowdownloadsignedenabled -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Enable application firewall----------------
# ----------------------------------------------------------
echo '--- Enable application firewall'
/usr/libexec/ApplicationFirewall/socketfilterfw --setglobalstate on
sudo defaults write /Library/Preferences/com.apple.alf globalstate -bool true
defaults write com.apple.security.firewall EnableFirewall -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------------Enable firewall logging------------------
# ----------------------------------------------------------
echo '--- Enable firewall logging'
/usr/libexec/ApplicationFirewall/socketfilterfw --setloggingmode on
sudo defaults write /Library/Preferences/com.apple.alf loggingenabled -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------------Enable stealth mode--------------------
# ----------------------------------------------------------
echo '--- Enable stealth mode'
/usr/libexec/ApplicationFirewall/socketfilterfw --setstealthmode on
sudo defaults write /Library/Preferences/com.apple.alf stealthenabled -bool true
defaults write com.apple.security.firewall EnableStealthMode -bool true
# ----------------------------------------------------------


# Enable password requirement for waking from sleep or screen saver
echo '--- Enable password requirement for waking from sleep or screen saver'
sudo defaults write /Library/Preferences/com.apple.screensaver askForPassword -bool true
# ----------------------------------------------------------


# Enable session lock five seconds after screen saver initiation
echo '--- Enable session lock five seconds after screen saver initiation'
sudo defaults write /Library/Preferences/com.apple.screensaver 'askForPasswordDelay' -int 5
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------------Disable guest account login----------------
# ----------------------------------------------------------
echo '--- Disable guest account login'
sudo defaults write '/Library/Preferences/com.apple.loginwindow' 'GuestEnabled' -bool NO
if ! command -v 'sysadminctl' &> /dev/null; then
    echo 'Skipping because "sysadminctl" is not found.'
else
    sudo sysadminctl -guestAccount off
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Disable guest file sharing over SMB------------
# ----------------------------------------------------------
echo '--- Disable guest file sharing over SMB'
sudo defaults write '/Library/Preferences/SystemConfiguration/com.apple.smb.server' 'AllowGuestAccess' -bool NO
if ! command -v 'sysadminctl' &> /dev/null; then
    echo 'Skipping because "sysadminctl" is not found.'
else
    sudo sysadminctl -smbGuestAccess off
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Disable guest file sharing over AFP------------
# ----------------------------------------------------------
echo '--- Disable guest file sharing over AFP'
sudo defaults write '/Library/Preferences/com.apple.AppleFileServer' 'guestAccess' -bool NO
if ! command -v 'sysadminctl' &> /dev/null; then
    echo 'Skipping because "sysadminctl" is not found.'
else
    sudo sysadminctl -afpGuestAccess off
fi
sudo killall -HUP AppleFileServer
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------Disable incoming SSH and SFTP remote logins--------
# ----------------------------------------------------------
echo '--- Disable incoming SSH and SFTP remote logins'
echo 'yes' | sudo systemsetup -setremotelogin off
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------------Disable the insecure TFTP service-------------
# ----------------------------------------------------------
echo '--- Disable the insecure TFTP service'
sudo launchctl disable 'system/com.apple.tftpd'
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------Disable Bonjour multicast advertising-----------
# ----------------------------------------------------------
echo '--- Disable Bonjour multicast advertising'
sudo defaults write /Library/Preferences/com.apple.mDNSResponder.plist NoMulticastAdvertisements -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------Disable insecure telnet protocol-------------
# ----------------------------------------------------------
echo '--- Disable insecure telnet protocol'
sudo launchctl disable system/com.apple.telnetd
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------------Disable captive portal detection-------------
# ----------------------------------------------------------
echo '--- Disable captive portal detection'
sudo defaults write '/Library/Preferences/SystemConfiguration/com.apple.captive.control.plist' Active -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----Disable local printer sharing with other computers----
# ----------------------------------------------------------
echo '--- Disable local printer sharing with other computers'
cupsctl --no-share-printers
# ----------------------------------------------------------


# Disable printing from external addresses, including the internet
echo '--- Disable printing from external addresses, including the internet'
cupsctl --no-remote-any
# ----------------------------------------------------------


# ----------------------------------------------------------
# ----------Disable remote printer administration-----------
# ----------------------------------------------------------
echo '--- Disable remote printer administration'
cupsctl --no-remote-admin
# ----------------------------------------------------------


# ----------------------------------------------------------
# -Clear logs of all downloaded files from File Quarantine--
# ----------------------------------------------------------
echo '--- Clear logs of all downloaded files from File Quarantine'
db_file=~/Library/Preferences/com.apple.LaunchServices.QuarantineEventsV2
db_query='delete from LSQuarantineEvent'
if [ -f "$db_file" ]; then
    echo "Database exists at \"$db_file\""
    if ls -lO "$db_file" | grep --silent 'schg'; then
        sudo chflags noschg "$db_file"
        echo "Found and removed system immutable flag"
        has_system_immutable_flag=true
    fi
    if ls -lO "$db_file" | grep --silent 'uchg'; then
        sudo chflags nouchg "$db_file"
        echo "Found and removed user immutable flag"
        has_user_immutable_flag=true
    fi
    sqlite3 "$db_file" "$db_query"
    echo "Executed the query \"$db_query\""
    if [ "$has_system_immutable_flag" = true ] ; then
        sudo chflags schg "$db_file"
        echo "Added system immutable flag back"
    fi
    if [ "$has_user_immutable_flag" = true ] ; then
        sudo chflags uchg "$db_file"
        echo "Added user immutable flag back"
    fi
else
    echo "No action needed, database does not exist at \"$db_file\""
fi
# ----------------------------------------------------------


# ----------------------------------------------------------
# --Clear File Quarantine attribute from downloaded files---
# ----------------------------------------------------------
echo '--- Clear File Quarantine attribute from downloaded files'
find ~/Downloads        \
        -type f         \
        -exec           \
            sh -c       \
                '
                    attr="com.apple.quarantine"
                    file="{}"
                    if [[ $(xattr "$file") = *$attr* ]]; then
                        if xattr -d "$attr" "$file" 2>/dev/null; then
                            echo "🧹 Cleaned attribute from \"$file\""
                        else
                            >&2 echo "❌ Failed to clean attribute from \"$file\""
                        fi
                    else
                        echo "No attribute in \"$file\""
                    fi
                '       \
            {} \;
# ----------------------------------------------------------


# ----------------------------------------------------------
# ------Disable downloaded file logging in quarantine-------
# ----------------------------------------------------------
echo '--- Disable downloaded file logging in quarantine'
file_to_lock=~/Library/Preferences/com.apple.LaunchServices.QuarantineEventsV2
if [ -f "$file_to_lock" ]; then
    sudo chflags schg "$file_to_lock"
    echo "Made file immutable at \"$file_to_lock\""
else
    echo "No action is needed, file does not exist at \"$file_to_lock\""
fi
# ----------------------------------------------------------


# Disable extended quarantine attribute for downloaded files (disables warning)
echo '--- Disable extended quarantine attribute for downloaded files (disables warning)'
sudo defaults write com.apple.LaunchServices 'LSQuarantine' -bool NO
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----------Disable automatic checks for updates-----------
# ----------------------------------------------------------
echo '--- Disable automatic checks for updates'
# For OS X Yosemite and newer (>= 10.10)
sudo defaults write /Library/Preferences/com.apple.SoftwareUpdate 'AutomaticCheckEnabled' -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------Disable automatic downloads for updates----------
# ----------------------------------------------------------
echo '--- Disable automatic downloads for updates'
# For OS X Yosemite and newer (>= 10.10)
sudo defaults write /Library/Preferences/com.apple.SoftwareUpdate 'AutomaticDownload' -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----Disable automatic installation of macOS updates------
# ----------------------------------------------------------
echo '--- Disable automatic installation of macOS updates'
# For OS X Yosemite through macOS High Sierra (>= 10.10 && < 10.14)
sudo defaults write /Library/Preferences/com.apple.commerce 'AutoUpdateRestartRequired' -bool false
# For Mojave and newer (>= 10.14)
sudo defaults write /Library/Preferences/com.apple.SoftwareUpdate 'AutomaticallyInstallMacOSUpdates' -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# -----Disable automatic app updates from the App Store-----
# ----------------------------------------------------------
echo '--- Disable automatic app updates from the App Store'
# For OS X Yosemite and newer (>= 10.10)
sudo defaults write /Library/Preferences/com.apple.commerce 'AutoUpdate' -bool false
# For Mojave and newer (>= 10.14)
sudo defaults write /Library/Preferences/com.apple.SoftwareUpdate 'AutomaticallyInstallAppUpdates' -bool false
# ----------------------------------------------------------


# ----------------------------------------------------------
# ---------Disable macOS beta release installation----------
# ----------------------------------------------------------
echo '--- Disable macOS beta release installation'
# For OS X Yosemite and newer (>= 10.10)
sudo defaults write /Library/Preferences/com.apple.SoftwareUpdate 'AllowPreReleaseInstallation' -bool false
# ----------------------------------------------------------


# Disable automatic installation for configuration data (e.g. XProtect, Gatekeeper, MRT)
echo '--- Disable automatic installation for configuration data (e.g. XProtect, Gatekeeper, MRT)'
# For OS X Yosemite and newer (>= 10.10)
sudo defaults write /Library/Preferences/com.apple.SoftwareUpdate 'ConfigDataInstall' -bool false
# ----------------------------------------------------------


# Disable automatic installation for system data files and security updates
echo '--- Disable automatic installation for system data files and security updates'
# For OS X Yosemite and newer (>= 10.10)
sudo defaults write /Library/Preferences/com.apple.SoftwareUpdate 'CriticalUpdateInstall' -bool false
# ----------------------------------------------------------


# Disable library validation entitlement (library signature validation)
echo '--- Disable library validation entitlement (library signature validation)'
sudo defaults write /Library/Preferences/com.apple.security.libraryvalidation.plist 'DisableLibraryValidation' -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# -------Disable Gatekeeper's automatic reactivation--------
# ----------------------------------------------------------
echo '--- Disable Gatekeeper'\''s automatic reactivation'
sudo defaults write /Library/Preferences/com.apple.security GKAutoRearm -bool true
# ----------------------------------------------------------


# ----------------------------------------------------------
# --------------------Disable Gatekeeper--------------------
# ----------------------------------------------------------
echo '--- Disable Gatekeeper'
os_major_ver=$(sw_vers -productVersion | awk -F "." '{print $1}')
os_minor_ver=$(sw_vers -productVersion | awk -F "." '{print $2}')
if [[ $os_major_ver -le 10 \
        || ( $os_major_ver -eq 10 && $os_minor_ver -lt 7 ) \
    ]]; then
    echo "No action needed, Gatekeeper is not available this OS version"
else
    gatekeeper_status="$(spctl --status | awk '/assessments/ {print $2}')"
    if [ $gatekeeper_status = "disabled" ]; then
        echo "No action needed, Gatekeeper is already disabled"
    elif [ $gatekeeper_status = "enabled" ]; then
        sudo spctl --master-disable
        sudo defaults write '/var/db/SystemPolicy-prefs' 'enabled' -string 'no'
        echo "Disabled Gatekeeper"
    else
        >&2 echo "Unknown gatekeeper status: $gatekeeper_status"
    fi
fi
# ----------------------------------------------------------


echo 'Your privacy and security is now hardened 🎉💪'
echo 'Press any key to exit.'
read -n 1 -s